/* Partie interactive du programme v-Jemaf 6 */

$(window).ready(function() {

	/* ******************************* SIMPLE / DOUBLE ECRAN / PREVISUALISATION ********************** */
	
	//Ecran de prévisualisation ou non
	const PREV = (window.location.href.search('prev_') > 0 ? "prev_" : "");
	
	$('#code').focus();
	
	//Affichage en douceur
	$('.chant, .div-Bible').fadeIn(2500);
	
	//Affichage du menu
	$('#menu').click(function(){
		if (!$('aside').queue().length) {
			if ($('aside').css('display') == "block")
				$('aside').slideUp(500);	
			else $('aside').slideDown(500);
		}
	});
	
	//Fermeture du menu
	$('aside a').click(function(){
		$('aside').slideUp(500);
	});
		
	//Double-clic sur le numéro
	$('#numero, #t-numero').dblclick(function(){
		$('#code').val($(this).text()).focus();
	});
	
	//Redirection automatique de la lecture biblique
	$('#send_ref').submit();
	
	//Clic sur un lien de chant
	$('.index p.res-index').click(function(){
		window.location = PREV + "chant=" + $(this).find('span').text().toLowerCase();
	});
	
	//Clic sur un lien de verset
	$('.index .verset').click(function(){
		$('#code').val($(this).find('small').text());
		$('#form_code').submit();
	});
	
	//Clic sur les résumés
	$('.index .resume').click(function(){
		taille = Math.min(10000, $(this).next('.details').height());
		if ($(this).hasClass('ouvert')) {
			$(this).removeClass('ouvert');
			$(this).next('.details').stop().slideUp(250 + taille/2);
		}
		else {
			$(this).addClass('ouvert');
			$(this).next('.details').slideDown(250 + taille);
		}
	});
	
	//Choix du livre biblique de lecture
	$('#livre_NT').change(function(){
		$('#livre_AT').attr('required', false).val('');
	});
	
	$('#livre_AT').change(function(){
		$('#livre_NT').val('');
	});
	
	//Affichage du champ Livre de la Bible
	function affLivre() {
		if ($('#rech-dans-b').val() == "livre")
			$('#div-livre').fadeIn(1000);
		else $('#div-livre').fadeOut(1000);
	}
	affLivre();
	$('#rech-dans-b').change(affLivre);
	
	//Clic sur la version de la Bible dans les résultats
	$('#radio_segond').click(function(){
		$('#res-semeur').hide(1000);
		$('#res-segond').fadeIn(2000);
	});
	
	$('#radio_semeur').click(function(){
		$('#res-segond').hide(1000);
		$('#res-semeur').fadeIn(2000);
	});
	
	//Contrôle de saisie des paramètres
	function verifie_checkbox(param) {
		liste = $('input[name="' + param + '[]"]:checked').map(function(){return $(this).val()}).get();
		if (liste != "") $('input[name="' + param + '[]"]').attr('required', false);
	}
	
	//Suppression des required des paramètres
	$('#param_submit').click(function(){
		verifie_checkbox('Recueils');
		verifie_checkbox('Versions');
	});
	
	/* ******************************* SIMPLE ECRAN ************************************* */
	
	if (!window.opener){
		
		//Clic sur un lien de navigation
		$('#nav-droite a').click(function(){
			if ($(this).index() == 0) {	// Lien Titre
				$('#contenu').scrollTop(0);
				$('#nav-droite a').removeClass('actif').removeClass('vu');
			}
			if ($(this).index() == $('#nav-droite a').length - 1) // Dernier lien
				$('#fin').fadeIn(1500).css("display","block");
			else $('#fin').fadeOut(1500);
			
			$('#nav-droite a.actif').removeClass('actif').addClass('vu');
			$(this).addClass('actif');
		});
		
		//Scroll automatique pour garder le lien actif visible lors de l'avancer ou reculer 
		scrollAuto = function(){
			position = $('#nav-droite a.actif').position().top;
			scrollTop = $('#nav-droite').scrollTop();
			if (position < 0 || position > 30) 
				$('#nav-droite').scrollTop(scrollTop + position - 7);
		}
		
		//Clic sur le bouton Avancer
		function Avancer(){
			$('#nav-droite a:nth-child(' + ($('#nav-droite a.actif').index() + 2) + ')').click();
			scrollAuto();
			if ($('#nav-droite a.actif').length)
				window.location = $('#nav-droite a.actif').attr('href');
		}
		
		$('#droite').click(Avancer);
		
		function Reculer(){
			$('#nav-droite a:nth-child(' + ($('#nav-droite a.actif').index()) + ')').click();
			scrollAuto();
			if ($('#nav-droite a.actif').length)
				window.location = $('#nav-droite a.actif').attr('href');
		}
		
		//Raccourcis clavier
		$(window).keydown(function(e){
			switch (e.keyCode) {
				case 40 : case 34 : Avancer(); break;
				case 38 : case 33 : Reculer();
			}
		});
		
		//Scroll sur la page, sur les liens
		scrollWheel = function(e, h, div){
			delta = (e.originalEvent.detail || e.originalEvent.deltaY || -e.originalEvent.wheelDelta);
			div.scrollTop(div.scrollTop() + (delta > 0 ? 1 : -1) * h);
		}
		
		//Scroll sur la page
		$('#contenu').on('DOMMouseScroll mousewheel', function(e){scrollWheel(e, 100, $(this))});
		
		//Scroll sur les liens
		$('#nav-droite').on( 'DOMMouseScroll mousewheel', function(e){scrollWheel(e, 30, $(this))});
	
		//Ouverture de la télécommande
		$('#lien_double_ecran').click(function(){
			window.open('telecommande', 'telec', 'width=1204,height=636,top=200,left=200,resizable=yes');
		});

		
	}
		
	/* ******************************* TELECOMMANDE ************************************* */
	
	else {
		
		window.resizeTo(1220,702);
		
		//Redimensionnement en hauteur de la fenêtre
		resizeH = function(){
			height = $(window).height();
			$('#liste-compo').height(height - 54);
			$('#liens').height(height - 236);
			$('#previsualisation').height(height - 60);
		}
		resizeH();
		$(window).resize(resizeH);
		
		//Prévisualisation
		function previsualiser(){
			previsu = $('iframe').contents();
			$('#code', previsu).val($('#code').val());
			$('#form_code', previsu).submit();
		}
		$('#previsu').click(previsualiser);
		
		retour_numero = false;
		
		//Affichage
		function afficher() {
			$('#code', window.opener.document).val($('#code').val());
			$('#double_ecran', window.opener.document).val("double");
			$('#form_code', window.opener.document).submit();
			retour_numero = true;
			previsualiser();
		}
		$('#afficher').click(afficher);
		
		//Clic sur les liens
		$('#liens').on('click', 'li', function(){
			$('#liens li.actif').removeClass('actif').addClass('vu');
			href = $(this).addClass('actif').attr('href');
			scrollTop = $('#contenu', window.opener.document).scrollTop();
			offset = (href == "" ? 0 : $('a[name="' + href + '"]', window.opener.document).offset().top + scrollTop); 
			$('#contenu', window.opener.document).scrollTop(offset);
			if ($(this).index() == $('#liens li').length - 1) // Dernier lien
				$('#fin', window.opener.document).fadeIn(1500).css("display","block");
			else $('#fin', window.opener.document).fadeOut(1500);
		});
		
		//Présaisie initiale
		chargement_initial = true;
		
		//Présaisie du numéro
		$('iframe').load(function(){
			previsu = $('iframe').contents();
			if (retour_numero) {
				$('#t-numero').text($('#prev_numero .prev_numero', previsu).text());
				$('#t-titre').text($('#prev_numero .prev_titre', previsu).text());
				$('#liens').html($('#prev_liens', previsu).html());
				retour_numero = false;
			}
			$('#code').val($('#prev_numero .prev_numero', previsu).text());
			
			if (chargement_initial) {
				$('#code').val($('#numero', window.opener.document).text());
				afficher();
				chargement_initial = false;
			}
			
		});
		
		//Scroll automatique pour garder le lien actif visible lors de l'avancer ou reculer 
		scrollAuto = function(div, sens){
			if ($(div).length) {
				li = div + ' li.actif';
				divHeight = $(div).height();
				liHeight = $(li).outerHeight();
				position = $(li).position().top;
				scrollTop = $(div).scrollTop();
				if (position < liHeight || position > divHeight - 2 * liHeight) 
					if (sens)
						$(div).scrollTop(scrollTop + position - liHeight);
					else $(div).scrollTop(scrollTop - divHeight + position + 2 * liHeight);
			}
		}
		
		//Clic sur la Composition
		function compo_click(li){
			$('#liste-compo li.actif').attr('class', 'vu');
			href = li.addClass('actif').attr('href');
			$('#code').val(li.find('span').text());
		}
		
		//Avancer
		function telec_avancer(){
			$('#liens li:nth-child(' + ($('#liens li.actif').index() + 2) + ')').click();
			scrollAuto('#liens', 1);
		}
		$('#t-droite').click(telec_avancer);
		
		//Reculer
		function telec_reculer(){
			$('#liens li:nth-child(' + ($('#liens li.actif').index()) + ')').click();
			scrollAuto('#liens', 0);
		}
		
		//Clic sur la composition
		$('#liste-compo').on('click', 'li', function(){
			compo_click($(this));
			switch($('data').data('click_compo')) {
				case 'compo_2' : afficher(); break;
				case 'compo_1' : previsualiser();
			}
		});
		
		//Raccourcis clavier
		$(window).keyup(function(e){
			switch (e.keyCode) {
				case 13 : if (e.ctrlKey) previsualiser();
					else afficher(); break;
				case 34 : if (e.ctrlKey && $('#field_compo').css('display') != 'none') {
					compo_click($('#liste-compo li:nth-child(' + ($('#liste-compo li.actif').index() + 2) + ')'));
					scrollAuto('#liste-compo', 1);
					afficher();
					break;
				}					
				case 40 : telec_avancer(); break;
				case 33 : if (e.ctrlKey && $('#field_compo').css('display') != 'none') {
					compo_click($('#liste-compo li:nth-child(' + ($('#liste-compo li.actif').index()) + ')'));
					scrollAuto('#liste-compo', 0);
					afficher();
					break;
				}			
				case 38 : telec_reculer();
			}
		});
		
		//Scroll vers la page
		$('#t-droite').on('DOMMouseScroll mousewheel', function(e){
			delta = (e.originalEvent.detail || e.originalEvent.deltaY || -e.originalEvent.wheelDelta);
			$('#contenu', window.opener.document).scrollTop($('#contenu', window.opener.document).scrollTop() + (delta > 0 ? 1 : -1) * 100);
		});
		
		//Réduire la télécommande
		reduire = function(mode){	//true = composition, false = prévisualisation, 0 = paramètre, 
			compoWidth = $('#field_compo').outerWidth(true);
			centreWidth = $('#t-centre').outerWidth(true);
			previsuWidth = $('#field_previsu').outerWidth(true) + 6;
			param = $('data').data('ouv_telec').charAt(4);	//Ouv_0 = réduite, 1 = prévisu, 2 = composition, 3 = ouverte
			
			//Fermeture/Ouverture Compo
			if (mode === 0 && (param == "0" || param == "1") || mode === true) {
				if ($('#field_compo').css('display') == "inline-block") {
					$('#field_compo').fadeOut(500);
					compoWidth = - compoWidth;
				}
				else {
					$('#field_compo').fadeIn(500);
				}
				window.resizeBy(compoWidth, 0);
				window.moveBy(-compoWidth, 0);
			}
			
			//Fermeture/Ouverture Prévisu
			if (mode === 0 && (param == "0" || param == "2") || mode === false) {
				if ($('#field_previsu').css('display') == "inline-block") {
					$('#field_previsu').fadeOut(500);
					previsuWidth = - previsuWidth;
				}
				else {
					$('#field_previsu').fadeIn(500);
				}
				window.resizeBy(previsuWidth, 0);
			}
		}
		
		$('.reduire').mouseover(function(){
			if (!$(this).children().queue().length)
				$(this).children().fadeIn(1000);
		}).mouseleave(function(){
			$(this).children().fadeOut(500);
		});
		$('.reduire').click(function(){
			reduire(($(this)[0] == $('#reduire_compo')[0]));
		});
				
		reduire(0);
		
		//Ouverture de la Composition
		$('#lien_composition, #legend_composition').click(function(){
			composition = window.open('composition', 'Composition', 'width=330,height=477,top=150,left=100,resizable=yes');
		});
		
		//Ouverture de l'Edition
		$('#lien_edition, #legend_previsu').click(function(){
			edition = window.open('edition', 'Edition', 'width=830,height=710,top=150,left=600,resizable=yes');
		});
		
		//Fin du double écran
		$(window).bind('beforeunload', function() {
    		$('#code', window.opener.document).val($('#t-numero').text());
			$('#form_code', window.opener.document).submit();
			if (composition)
				composition.close();
			if (edition)
				edition.close();
		});
	
	}	
	
});